# SPDX-License-Identifier: Apache-2.0
# Copyright © 2017-2023 Intel Corporation

import argparse
import textwrap

HEADER = textwrap.dedent('''\
    void stringify(int foo, char * buffer);
    ''')

CODE = textwrap.dedent('''\
    #include <stdio.h>

    #ifndef WORKS
    # error "This shouldn't have been included"
    #endif

    void stringify(int foo, char * buffer) {
        sprintf(buffer, "%i", foo);
    }
    ''')


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--header')
    parser.add_argument('--code')
    args = parser.parse_args()

    with open(args.header, 'w') as f:
        f.write(HEADER)

    with open(args.code, 'w') as f:
        f.write(CODE)


if __name__ == '__main__':
    main()
